/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8224;

import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.modelgen.ConfigChangeDetector;
import ibm.nways.jdm.modelgen.LocalModel;
import ibm.nways.ras.RAS;
import java.util.Vector;

public class UnitChangeDetector
implements ConfigChangeDetector {
    private static int maxunits = 10;
    boolean shouldinit = true;
    boolean gotTimeout = false;
    int[] oldunits = new int[maxunits];
    int[] newunits = new int[maxunits];
    int[] oldmods = new int[maxunits];
    int[] newmods = new int[maxunits];
    private static final int RASID = 19;
    private static final int RASSUB = 1;

    public int[] unitlooker(LocalModel localModel) {
        int[] nArray = new int[maxunits];
        if (RAS.isEnabled(19, 1)) {
            RAS.enter(19, 1, this, "unitlooker");
        }
        try {
            LocalModel localModel2 = localModel.getComponent("Units");
            Vector vector = localModel2.getRestOfInfo("Panel", "default", null, null);
            int n = this.setlooksize(vector.size());
            int n2 = 0;
            while (n2 < n) {
                ModelInfo modelInfo = (ModelInfo)vector.elementAt(n2);
                if (modelInfo.timeoutDetected) {
                    this.gotTimeout = true;
                } else {
                    nArray[n2] = (Integer)modelInfo.get("Panel.StackIndex");
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            RAS.logException(19, 1, this, "unitlooker", exception);
        }
        if (RAS.isEnabled(19, 1)) {
            RAS.exit(19, 1, this, "unitlooker");
        }
        return nArray;
    }

    public int[] modlooker(LocalModel localModel) {
        int[] nArray = new int[maxunits];
        LocalModel localModel2 = null;
        Vector vector = null;
        if (RAS.isEnabled(19, 1)) {
            RAS.enter(19, 1, this, "modlooker");
        }
        try {
            localModel2 = localModel.getComponent("Units");
            if (localModel2 != null) {
                vector = localModel2.getRestOfInfo("Panel", "default", null, null);
                int n = this.setlooksize(vector.size());
                int n2 = 0;
                while (n2 < n) {
                    ModelInfo modelInfo = (ModelInfo)vector.elementAt(n2);
                    if (modelInfo.timeoutDetected) {
                        this.gotTimeout = true;
                    } else {
                        nArray[n2] = (Integer)modelInfo.get("Panel.ModuleType");
                    }
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            RAS.logException(19, 1, this, "unitlooker", exception);
        }
        if (RAS.isEnabled(19, 1)) {
            RAS.exit(19, 1, this, "modlooker");
        }
        return nArray;
    }

    public void init(LocalModel localModel) {
        if (RAS.isEnabled(19, 1)) {
            RAS.enter(19, 1, this, "init");
        }
        this.gotTimeout = false;
        this.oldunits = this.unitlooker(localModel);
        this.oldmods = this.modlooker(localModel);
        this.shouldinit = this.gotTimeout;
        if (RAS.isEnabled(19, 1)) {
            RAS.exit(19, 1, this, "init");
        }
    }

    public boolean configChanged(LocalModel localModel) {
        if (RAS.isEnabled(19, 1)) {
            RAS.enter(19, 1, this, "configChanged");
        }
        if (this.shouldinit) {
            if (RAS.isEnabled(19, 1)) {
                RAS.trace(19, 1, this, "configChanged", "need to be initialized");
            }
            this.init(localModel);
            return false;
        }
        this.gotTimeout = false;
        this.newunits = this.unitlooker(localModel);
        this.newmods = this.modlooker(localModel);
        if (this.gotTimeout) {
            if (RAS.isEnabled(19, 1)) {
                RAS.trace(19, 1, this, "configChanged", "timeout received - no detection process this poll");
            }
            return false;
        }
        int n = 0;
        while (n < maxunits) {
            if (RAS.isEnabled(19, 1)) {
                RAS.trace(19, 1, this, "configChanged", " old:" + this.oldunits[n] + " new:" + this.newunits[n]);
            }
            if (this.newunits[n] != this.oldunits[n]) {
                if (RAS.isEnabled(19, 1)) {
                    RAS.trace(19, 1, this, "configChanged", "detected a change in the stack");
                }
                this.oldunits = this.newunits;
                return true;
            }
            if (this.newmods[n] != this.oldmods[n]) {
                if (RAS.isEnabled(19, 1)) {
                    RAS.trace(19, 1, this, "configChanged", "detected a change in the modules");
                }
                this.oldmods = this.newmods;
                return true;
            }
            ++n;
        }
        if (RAS.isEnabled(19, 1)) {
            RAS.exit(19, 1, this, "configChanged");
        }
        return false;
    }

    private int setlooksize(int n) {
        if (n > maxunits) {
            if (RAS.isEnabled(19, 1)) {
                RAS.trace(19, 1, this, "configChanged", "Stack size exceeds defined limits");
            }
            return maxunits;
        }
        return n;
    }

    public void dispose() {
        if (RAS.isEnabled(19, 1)) {
            RAS.enter(19, 1, this, "dispose");
        }
        this.shouldinit = true;
        if (RAS.isEnabled(19, 1)) {
            RAS.exit(19, 1, this, "dispose");
        }
    }
}

